'use strict';

var beginAuth = require('./begin-auth.js');
var redirectWithExitiframe = require('./redirect-with-exitiframe.js');
var redirectWithAppBridgeHeaders = require('./redirect-with-app-bridge-headers.js');

async function redirectToAuthPage(params, request, shop, isOnline = false) {
    const { config } = params;
    const url = new URL(request.url);
    const isEmbeddedRequest = url.searchParams.get('embedded') === '1';
    const isXhrRequest = request.headers.get('authorization');
    if (isXhrRequest) {
        const redirectUri = new URL(config.auth.path, config.appUrl);
        redirectUri.searchParams.set('shop', shop);
        redirectWithAppBridgeHeaders.redirectWithAppBridgeHeaders(redirectUri.toString());
    }
    else if (isEmbeddedRequest) {
        redirectWithExitiframe.redirectWithExitIframe(params, request, shop);
    }
    else {
        throw await beginAuth.beginAuth(params, request, isOnline, shop);
    }
}

exports.redirectToAuthPage = redirectToAuthPage;
//# sourceMappingURL=redirect-to-auth-page.js.map
