'use strict';

var shopifyApi = require('@shopify/shopify-api');
require('@remix-run/server-runtime');
var redirectToAuthPage = require('../helpers/redirect-to-auth-page.js');
var invalidateAccessToken = require('../../helpers/invalidate-access-token.js');
require('isbot');
require('../../../types.js');

function createUsageRecordFactory(params, request, session) {
    return async function createUsageRecord(options) {
        const { api, logger } = params;
        logger.debug('Create usage record', { shop: session.shop, ...options });
        try {
            return await api.billing.createUsageRecord({
                ...options,
                session,
            });
        }
        catch (error) {
            if (error instanceof shopifyApi.HttpResponseError && error.response.code === 401) {
                logger.debug('API token was invalid, redirecting to OAuth', {
                    shop: session.shop,
                });
                await invalidateAccessToken.invalidateAccessToken(params, session);
                throw await redirectToAuthPage.redirectToAuthPage(params, request, session.shop);
            }
            else {
                throw error;
            }
        }
    };
}

exports.createUsageRecordFactory = createUsageRecordFactory;
//# sourceMappingURL=create-usage-record.js.map
