'use strict';

var jsxRuntime = require('react/jsx-runtime');
var React = require('react');

const AppProxyProviderContext = React.createContext(null);
/**
 * Sets up a page to render behind a Shopify app proxy, enabling JavaScript and CSS to be loaded from the app.
 *
 * Also provides components that enable using other components such as links and forms within proxies.
 *
 * > Caution:
 * Because Remix doesn't support URL rewriting, any route using this component should <b>match the pathname of the proxy
 * URL exactly</b>, and <b>end in a trailing slash</b> (e.g., `https://<shop>/apps/proxy/`).
 *
 * @example
 * <caption>Wrap a route with an AppProxyProvider component.</caption>
 * <description>Wrap your route component in the `AppProxyProvider` component and pass in your app URL.</description>
 * ```ts
 * // /app/routes/**\/*.ts
 * import {authenticate} from '~/shopify.server';
 * import {AppProxyProvider} from '@shopify/shopify-app-remix/react';
 *
 * export async function loader({ request }) {
 *   await authenticate.public.appProxy(request);
 *
 *   return json({ appUrl: process.env.SHOPIFY_APP_URL });
 * }
 *
 * export default function App() {
 *   const { appUrl } = useLoaderData();
 *
 *   return (
 *     <AppProxyProvider appUrl={appUrl}>
 *       Page content
 *     </AppProxyProvider>
 *   );
 * }
 * ```
 */
function AppProxyProvider(props) {
    const { children, appUrl } = props;
    const [requestUrl, setRequestUrl] = React.useState();
    React.useEffect(() => setRequestUrl(new URL(window.location.href)), [setRequestUrl]);
    return (jsxRuntime.jsxs(AppProxyProviderContext.Provider, { value: { appUrl, requestUrl, formatUrl: formatProxyUrl(requestUrl) }, children: [jsxRuntime.jsx("base", { href: appUrl }), children] }));
}
function formatProxyUrl(requestUrl) {
    return (url, addOrigin = true) => {
        if (!url) {
            return url;
        }
        let finalUrl = url;
        if (addOrigin && requestUrl && finalUrl.startsWith('/')) {
            finalUrl = new URL(`${requestUrl.origin}${url}`).href;
        }
        if (!finalUrl.endsWith('/')) {
            finalUrl = `${finalUrl}/`;
        }
        return finalUrl;
    };
}

exports.AppProxyProvider = AppProxyProvider;
exports.AppProxyProviderContext = AppProxyProviderContext;
//# sourceMappingURL=AppProxyProvider.js.map
