import { getHandlers, getTopicsAdded, addHandlers, registry } from './registry.mjs';
import { register } from './register.mjs';
import { process } from './process.mjs';
import { validateFactory } from './validate.mjs';

function shopifyWebhooks(config) {
    const webhookRegistry = registry();
    return {
        addHandlers: addHandlers(config, webhookRegistry),
        getTopicsAdded: getTopicsAdded(webhookRegistry),
        getHandlers: getHandlers(webhookRegistry),
        register: register(config, webhookRegistry),
        process: process(config, webhookRegistry),
        validate: validateFactory(config),
    };
}

export { shopifyWebhooks };
//# sourceMappingURL=index.mjs.map
