import crypto from 'crypto';
import fetch from 'node-fetch';
import { setAbstractFetchFunc, setAbstractConvertRequestFunc, setAbstractConvertIncomingResponseFunc, setAbstractConvertResponseFunc, setAbstractConvertHeadersFunc } from '../../runtime/http/index.mjs';
import '../../runtime/crypto/types.mjs';
import { setCrypto } from '../../runtime/crypto/crypto.mjs';
import { setAbstractRuntimeString } from '../../runtime/platform/runtime-string.mjs';
import { nodeConvertRequest, nodeConvertIncomingResponse, nodeConvertAndSendResponse, nodeConvertAndSetHeaders, nodeRuntimeString } from './adapter.mjs';

// For the purposes of this package, fetch correctly implements everything we need
setAbstractFetchFunc(fetch);
setAbstractConvertRequestFunc(nodeConvertRequest);
setAbstractConvertIncomingResponseFunc(nodeConvertIncomingResponse);
setAbstractConvertResponseFunc(nodeConvertAndSendResponse);
setAbstractConvertHeadersFunc(nodeConvertAndSetHeaders);
setAbstractRuntimeString(nodeRuntimeString);
setCrypto(crypto);
//# sourceMappingURL=index.mjs.map
