'use strict';

var jwt = require('jsonwebtoken');
var _const = require('./const.js');
var getShopValue = require('./get-shop-value.js');

/**
 * Creates and signs a JWT token to use in faking authorization for testing.
 *
 * @param store The name of the store for which to create a valid JWT token.
 * @param apiKey The Client ID/API key for the store for which to create a valid JWT token.
 * @param apiSecretKey The API secret for the store for which to create a valid JWT token.
 * @param overrides Optional overrides for the JWT payload.
 * @returns {TestJwt} The JWT token and the JWT payload used to create the token.
 */
function getJwt(store, apiKey, apiSecretKey, overrides = {}) {
    const date = new Date();
    const shop = getShopValue.getShopValue(store);
    const payload = {
        iss: `${shop}/admin`,
        dest: `https://${shop}`,
        aud: apiKey,
        sub: `${_const.USER_ID}`,
        exp: date.getTime() / 1000 + 3600,
        nbf: date.getTime() / 1000 - 3600,
        iat: date.getTime() / 1000 - 3600,
        jti: '1234567890',
        sid: '0987654321',
        ...overrides,
    };
    const token = jwt.sign(payload, apiSecretKey, {
        algorithm: 'HS256',
    });
    return { token, payload };
}

exports.getJwt = getJwt;
//# sourceMappingURL=get-jwt.js.map
