function generateGetHeaders(config) {
    return (customHeaders) => {
        return { ...(customHeaders ?? {}), ...config.headers };
    };
}
function generateGetGQLClientParams({ getHeaders, getApiUrl }) {
    return (operation, options) => {
        const props = [operation];
        if (options && Object.keys(options).length > 0) {
            const { variables, apiVersion: propApiVersion, headers, retries, signal, } = options;
            props.push({
                ...(variables ? { variables } : {}),
                ...(headers ? { headers: getHeaders(headers) } : {}),
                ...(propApiVersion ? { url: getApiUrl(propApiVersion) } : {}),
                ...(retries ? { retries } : {}),
                ...(signal ? { signal } : {}),
            });
        }
        return props;
    };
}

export { generateGetGQLClientParams, generateGetHeaders };
//# sourceMappingURL=utilities.mjs.map
