# `@shopify/app-bridge-types`

**[Join our team and work on libraries like this one.](https://www.shopify.ca/careers)**

[![License: ISC](https://img.shields.io/badge/License-ISC-green.svg)](LICENSE.md)

This is a companion library with TypeScript types for [Shopify App Bridge](https://shopify.dev/docs/api/app-bridge).

## Installation

You can install Shopify App Bridge Types by using [Yarn](https://yarnpkg.com):

```sh
yarn add --dev @shopify/app-bridge-types
```

## Development

### How Types are Generated

The types in this package are automatically generated from the `sandboxes/app-bridge-next` source code:

1. Types are defined in `sandboxes/app-bridge-next/src/features/` 
2. During build, they're compiled to `sandboxes/app-bridge-next/dist/app-bridge.d.ts`
3. The build script (`scripts/build.mjs`) processes and copies these types to the `dist` folder
4. The processed types are then published to npm

### Releasing a New Version

To release a new version of the types package:

1. Make your changes to the type definitions in `sandboxes/app-bridge-next/src/features/`
2. Run `pnpm changeset` from the root of the repository
3. Select `@shopify/app-bridge-types` to bump its version
4. Commit your changes
5. CI will automatically handle building and publishing the updated package

The automation ensures that the types stay in sync with the app-bridge-next implementation.
