import { preset as preset$1 } from '@shopify/graphql-codegen';
import { apiConfigs } from './helpers/api-configs.mjs';

const preset = {
    buildGeneratesSection: (options) => {
        const apiType = options.presetConfig.apiType;
        const { interfaceExtension, module, presetConfigs } = apiConfigs[apiType];
        const typesFile = apiConfigs[apiType].typesFile;
        return preset$1.buildGeneratesSection({
            ...options,
            presetConfig: {
                ...presetConfigs,
                importTypes: {
                    namespace: presetConfigs.importTypes.namespace,
                    from: `./${typesFile}`,
                },
                interfaceExtension: ({ queryType, mutationType, }) => interfaceExtension
                    .replace('%%MODULE%%', options.presetConfig.module ?? module)
                    .replace('%%QUERY%%', queryType)
                    .replace('%%MUTATION%%', mutationType),
            },
        });
    },
};

export { preset };
//# sourceMappingURL=preset.mjs.map
