import {
  Page,
  Layout,
  Text,
  Card,
  Button,
  BlockStack,
  Box,
  List,
  Link,
  InlineStack,
} from "@shopify/polaris";
import { TitleBar, useAppBridge } from "@shopify/app-bridge-react";
import { authenticate } from "../shopify.server";

export const loader = async ({ request }) => {
  await authenticate.admin(request);

  return null;
};

export default function Index() {
  const shopify = useAppBridge();

  return (
    <Page title="Dashboard">
   <div style={{ width: "320px" }}>
  <Card>
    <div style={{ padding: "16px" }}>
      <Text variant="headingMd" as="h6">Products Overview</Text>

      <div style={{
        display: "flex",
        justifyContent: "space-between",
        marginTop: "20px",
        textAlign: "center",
      }}>
        
        {/* Total Listings */}
        <div>
          <Text variant="heading3xl"  tone="info">
            174
          </Text>
          <Text  variant="headingSm" as="h6>Total Products</Text>
        </div>

        {/* Uploaded Products */}
        <div>
          <Text variant="heading3xl"  as="h3" tone="info">
            12
          </Text>
          <Text tone="subdued">Imported Products</Text>
        </div>

      </div>  
    </div>
  </Card>
</div>

    </Page>
  );
}
