import {
  Page,
  Layout,
  Text,
  Card,
  Button,
  BlockStack,
  Box,
  List,
  Link,
  InlineStack,
} from "@shopify/polaris";
import { TitleBar, useAppBridge } from "@shopify/app-bridge-react";
import { authenticate } from "../shopify.server";

export const loader = async ({ request }) => {
  await authenticate.admin(request);

  return null;
};

export default function Index() {
  const shopify = useAppBridge();

  return (
    <Page title="Dashboard">
   <div style={{ width: "420px" }}>
  <Card>
    <div style={{ padding: "16px" }}>
      <Text variant="headingMd" as="h6">Etsy Products Overview</Text>

      <div style={{
        display: "flex",
        justifyContent: "space-between",
        marginTop: "20px",
        textAlign: "center",
      }}>
        
        {/* Total Listings */}
        <div>
          <Text variant="headingLg" as="h3" tone="info">
            174
          </Text>
          <Text tone="subdued">Total Listings</Text>
        </div>

        {/* Uploaded Products */}
        <div>
          <Text variant="headingLg" as="h3" tone="info">
            12
          </Text>
          <Text tone="subdued">Uploaded Products</Text>
        </div>

        {/* Linked Products */}
        <div>
          <Text variant="headingLg" as="h3" tone="success">
            24
          </Text>
          <Text tone="subdued">Linked Products</Text>
        </div>

      </div>  
    </div>
  </Card>
</div>

    </Page>
  );
}
