import { json } from "@remix-run/node";
import prisma from "../db.server";

export const action = async ({ request }) => {
  try {
    const body = await request.json();
    const { data, userId } = body; // data = "priceOnly" | "inventoryOnly" | "syncBoth" | "none"

    let inventory_sync = "0";
    let price_sync = "0";

    console.log("data    ", data);


    // map selected option to DB values
    switch (data[0]) {
      case "priceOnly":
        price_sync = "1";
        break;
      case "inventoryOnly":
        inventory_sync = "1";
        break;
      case "syncBoth":
        inventory_sync = "1";
        price_sync = "1";
        break;
      case "none":
      default:
        // leave both as "0"
        break;
    }

    // check if settings exist
    const existingSetting = await prisma.setting.findUnique({
      where: { user_id: userId },
    });


    if (!existingSetting) {
      await prisma.setting.create({
        data: {
          user_id: userId,
          markupenabled: false,
          markuptype: "FIXED",
          markupval: 0,
          markupvalfixed: 0,
          markupround: false,
          shopifylocationid: "",
          inventory_sync,
          price_sync,
          published: "1",
      
        },
      });
    } else {
      // update existing
      await prisma.setting.update({
        where: { user_id: userId },
        data: {
          inventory_sync,
          price_sync,
        },
      });
    }
    await prisma.users.update({
      where: { id: userId },
      data: {
        setup_step: "Done",
      },
    });
    return json({ msg: "Setting Updated", success: true });
  } catch (error) {
    console.error("Error updating settings:", error);
    return json(
      { msg: "Setting Not Updated", success: false },
      { status: 500 },
    );
  }

  async function shopifyGraphQL(query, shopurl, token) {
    const endpoint = `https://${shopurl}/admin/api/2025-07/graphql.json`;

    const response = await fetch(endpoint, {
      method: "POST",
      headers: {
        "Content-Type": "application/json",
        "X-Shopify-Access-Token": token,
      },
      body: JSON.stringify({ query }),
    });

    if (!response.ok) {
      console.error("Shopify API Error:", await response.text());
      throw new Error("Failed to fetch from Shopify API");
    }

    return await response.json();
  }
};
