// import { json } from "@remix-run/node";
// import prisma from "../db.server";

// export const loader = async ({request}) => {
//   try {
//     const url = new URL(request.url);
//     const userId = url.searchParams.get("userId");

//     const products = await prisma.products.findMany({
//        where:{user_id:Number(userId)},
//       select: {
//         product_id: true,
//         title: true,
//         status: true,
//         description: true,
//         created_at:true,
//       },
//       orderBy: { created_at: "desc" },
//     });

//     const productIds = products.map((p) => p.product_id);

//     const variants = await prisma.product_variants.findMany({
//       where: { product_id: { in: productIds } },
//       select: {
//         id: true,
//         product_id: true,
//         price: true,
//         asin:true,
//         sku: true,
//         quantity: true,
//         option1val:true,
//         option2val:true,
//         option3val:true,
//       },
//     });

//     const asins = variants.map(v => v.asin);

//      const images = await prisma.pc_images.findMany({
//       where: { 
//         asin: { in: asins,}
//       },
//       select: {
//         asin: true,
//         imageArr: true,
//       },
//     });

//     const productsWithData = products.map((p) => {
//       const productVariants = variants.filter(v => v.product_id === p.product_id);

//       const firstVariant = productVariants[0]; 
//       const matchedImages = images.find(img => img.asin === firstVariant?.asin);

//       const firstImage = matchedImages?.imageArr ?? null;

//       return {
//         ...p,
//         variants: productVariants,
//         firstImage,
//       };
//     });

//     return json({ products: productsWithData });
//   } catch (error) {
//     console.error("Loader error:", error);
//     return json({ error: error.message }, { status: 500 });
//   }
// };
import { json } from "@remix-run/node";
import prisma from "../db.server";

export const loader = async ({ request }) => {
  const url = new URL(request.url);
  let orderByTitle = false;
  let orderBy = "desc";
  const userId = parseInt(url.searchParams.get("user_id"), 10);
  const status = url.searchParams.get("status");
  const query = url.searchParams.get("query");
  const order = url.searchParams.get("orderBy");
  const parPage = parseInt(url.searchParams.get("parPage"));
  const page = parseInt(url.searchParams.get('page'));
  let keywords = [];
  if (query) {
    
     keywords = query.split(/\s+/).filter(Boolean);
  }

  let skip = parPage*(page-1);
  console.log("skip : ",skip);
  if (order === "Title asc" || order === "Title desc") {
    orderByTitle = true;
    orderBy = order === "Title asc" ? "asc" : "desc";
  }
  if (order === "Product desc" || order === "Product asc") {
    orderBy = order === "Product asc" ? "asc" : "desc";
  }
  const statusMap = {
    "already exist": "Already_Exist",
    "ready to import": "Ready_to_Import",
    "import in progress": "Import_in_progress",
    "imported": "Imported",
    "error": "error",
    "reimport in progress": "reimport_in_progress",
    "linked": "linked",
  };
  const normalizedStatus = status?.toLowerCase();
  const prismaStatus = normalizedStatus && normalizedStatus !== "all" ? statusMap[normalizedStatus] : undefined;
  const where = {
    user_id: userId,
    ...(prismaStatus && { status: prismaStatus }),
    ...(keywords.length && {
      AND: keywords.map((word) => ({
        title: {
          contains: word.trim(),
        },
      })),
    }),
  };


  // Get total count of matching products
  const totalCount = await prisma.products.count({ where });
  const totalProduct = await prisma.products.count({ 
    where:{
        user_id:userId
    }
   });


      const products = await prisma.products.findMany({
       where:{user_id:Number(userId)},
      select: {
        product_id: true,
        title: true,
        status: true,
        description: true,
        created_at:true,
      },
      orderBy: { created_at: "desc" },
    });

    const productIds = products.map((p) => p.product_id);

    const variants = await prisma.product_variants.findFirst({
      where: { product_id: { in: productIds } },
      select: {
        id: true,
        product_id: true,
        price: true,
        asin:true,
        sku: true,
        quantity: true,
        option1val:true,
        option2val:true,
        option3val:true,
      },
    });

    const asins = variants.map(v => v.asin);

     const images = await prisma.pc_images.findMany({
      where: { 
        asin: { in: asins,}
      },
      select: {
        asin: true,
        imageArr: true,
      },
    });

    const productsWithData = products.map((p) => {
      const productVariants = variants.filter(v => v.product_id === p.product_id);
      const firstVariant = productVariants[0]; 
      const matchedImages = images.find(img => img.asin === firstVariant?.asin);
      const firstImage = matchedImages?.imageArr ?? null;
      return {
        ...p,
        variants: productVariants,
        firstImage,
      };
    });

  if (!products.length) {
    return json({ error: "Products not found" }, { status: 404 });
  }

  return json({ productsWithData, totalCount,totalProduct });
};