import { json } from "@remix-run/node";
import prisma from "../db.server";

export const action = async ({ request }) => {
  try {
    const body = await request.json();
    const { product_id } = body;
    

    return json({ success: true, data: [] });
  } catch (error) {
    console.error("Fetch variants error:", error);
    return json({ success: false, message: error.message }, { status: 500 });
  }
};
